
function AISMN_GoToBuildingConstruct::OnEnter(%this,%obj)
{
	//Is the target a building? If not, we'll set a flag denoting it isn't.
	%tar = GetParameterTarget(%obj);
	%component = slgQueryInterface(%tar, $CID_BUILDING); 
   if (!%component)
   {
      SetStateVariable(%obj,0,1);
      return;
   }
   
   %xPos = GetParameterX(%obj);
   %yPos = GetParameterY(%obj);
   %object = GetThisObject(%obj);
   if (IsSameRegion(%object, %xPos, %yPos) == false)
   {
      SendHudMessage(%object.name @ " cannot reach the " @
         %tar.getType() @ " construction site.");
      SetStateVariable(%obj,0,1);
      return;
   }
   
   SetPathToSpot(%obj, %xPos, %yPos);
   GetThisObject(%obj).playThread( 0, "run");
}

function AISMN_GoToBuildingConstruct::OnExit(%this,%obj)
{
   %object = GetThisObject(%obj);
   %object.playThread( 0, "root");
}

function AISMN_GoToBuildingConstruct::Update(%this,%obj)
{
   //If it wasn't a building, exit.
   if(GetStateVariable(%obj,0) >= 1)
   {
      ReturnValue(%obj, 0);
      return;
   }
   
   // if the building's construction state has been creached, the
   // building has started being built, so quit this building command
   %target = GetParameterTarget(%obj);
   if (%target.isLinkObj() == true && %target.linkStart == false)
   {
      %target = %target.getLastLinkObj();
      SetParameterTarget(%obj, %target);
   }
   
   %building = slgQueryInterface(%target, $CID_BUILDING);
   if (isObject(%building) == true && %building.getState() != $BuildingState::NoState)
   {
      StopMoving(%obj);
      ReturnValue(%obj, 0);
      return;
   }
   
   // if we have reached the building, we are done
	if(!IsFollowingPath(%obj))
   {
      ReturnValue(%obj, 1);
      return;
   }
	
   ReturnValue(%obj, -1);
}




function AISMN_GoToBuildingRepair::OnEnter(%this,%obj)
{
	//Is the target a building? If not, we'll set a flag denoting it isn't.
	%tar = GetParameterTarget(%obj);
	%component = slgQueryInterface(%tar, $CID_BUILDING); 
   if (!%component)
   {
      SetStateVariable(%obj,0,1);
      return;
   }
   SetPathToSpot( %obj, GetParameterX(%obj),GetParameterY(%obj) );
   GetThisObject(%obj).playThread( 0, "run");
}

function AISMN_GoToBuildingRepair::OnExit(%this,%obj)
{
   GetThisObject(%obj).playThread( 0, "root");
}

function AISMN_GoToBuildingRepair::Update(%this,%obj)
{
   //If it wasn't a building, exit.
   if(GetStateVariable(%obj,0) >= 1)
   {
      ReturnValue(%obj, 0);
      return;
   }
   
   // if we have reached the building, we are done
	if(!IsFollowingPath(%obj))
   {
      ReturnValue(%obj, 1);
      return;
   }
	
   ReturnValue(%obj, -1);
}
